using System;
using Borland.Eco.Services;
using Borland.Eco.UmlCodeAttributes;

namespace ModelAuditor
{
	[EcoSpace]
	[EcoSpacePackage(typeof(ModelAuditor.Package_1))]
	public class ModelAuditorEcoSpace: Borland.Eco.Handles.DefaultEcoSpace
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private Borland.Eco.Persistence.PersistenceMapperXml persistenceMapperXml1;
		private void InitializeComponent()
		{
			this.persistenceMapperXml1 = new Borland.Eco.Persistence.PersistenceMapperXml();
			// 
			// persistenceMapperXml1
			// 
			this.persistenceMapperXml1.FileName = "AuditRules.xml";
			// 
			// ModelAuditorEcoSpace
			// 
			this.PersistenceMapper = this.persistenceMapperXml1;
		}

		public ModelAuditorEcoSpace(): base()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				Active = false;
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		private static ITypeSystemService m_TypeSystemProvider;
		public static new ITypeSystemService GetTypeSystemService()
		{
		if (m_TypeSystemProvider == null)
				lock(typeof(ModelAuditorEcoSpace))
				{
					if (m_TypeSystemProvider == null)
						m_TypeSystemProvider = MakeTypeService(typeof(ModelAuditorEcoSpace));
				}
			return m_TypeSystemProvider;
		}
		protected override ITypeSystemService GetTypeSystemProvider()
		{
			return ModelAuditorEcoSpace.GetTypeSystemService();
		}
		//
		// Services
		//
		public IPersistenceService PersistenceService
		{
			get { return (IPersistenceService)GetEcoService(typeof(IPersistenceService)); }
		}
		public IDirtyListService DirtyListService
		{
			get { return (IDirtyListService)GetEcoService(typeof(IDirtyListService)); }
		}
		public IUndoService UndoService
		{
			get { return (IUndoService)GetEcoService(typeof(IUndoService)); }
		}
		public ITypeSystemService TypeSystemService
		{
			get { return (ITypeSystemService)GetEcoService(typeof(ITypeSystemService)); }
		}
		public IOclService OclService
		{
			get { return (IOclService)GetEcoService(typeof(IOclService)); }
		}
		public IObjectFactoryService ObjectFactoryService
		{
			get { return (IObjectFactoryService)GetEcoService(typeof(IObjectFactoryService)); }
		}
		public IVariableFactoryService VariableFactoryService
		{
			get { return (IVariableFactoryService)GetEcoService(typeof(IVariableFactoryService)); }
		}
		//
		// Misc helper functions
		//
		public void UpdateDatabase()
		{
			if ((PersistenceService != null) && (DirtyListService != null))
			{
				PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects());
			}
		}
		//
		// Add user written methods here
		//
	}
}
